import { GraduationCap, Mail, Phone, MapPin, Clock, Instagram, Facebook, MessageCircle } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <div className="footer-logo-icon-wrapper">
                <GraduationCap size={28} strokeWidth={2.5} />
                <div className="footer-logo-glow"></div>
              </div>
              <h2 className="footer-logo-text">ЕГЭ-Профи</h2>
            </div>
            <p className="footer-description">
              Профессиональная подготовка к ЕГЭ с индивидуальным подходом. 
              Достигайте высоких результатов вместе с нашими опытными преподавателями.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Instagram size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Facebook size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <MessageCircle size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><a href="/">Мои курсы</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@ege-profi.ru">info@ege-profi.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. Образовательная, 15</span>
              </li>
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Пн-Вс: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 ЕГЭ-Профи. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

